% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_teamdrive.R
\name{as_team_drive}
\alias{as_team_drive}
\title{Coerce to Team Drive}
\usage{
as_team_drive(x, ...)
}
\arguments{
\item{x}{A vector of Team Drive names, a vector of Team Drive ids marked
with \code{\link[=as_id]{as_id()}}, a list of Team Drive Resource objects, or a suitable data
frame.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\description{
Converts various representations of Team Drive into a
\code{\link{dribble}}, the object used by googledrive to hold Drive file metadata.
Team Drives can be specified via
\itemize{
\item Name.
\item Team Drive id. Mark with \code{\link[=as_id]{as_id()}} to distinguish from name.
\item Data frame or \code{\link{dribble}} consisting solely of Team Drives.
\item List representing \href{https://developers.google.com/drive/v3/reference/teamdrives#resource-representations}{Team Drive resource}
objects. Mostly for internal use.
}

Note: \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
are only available to users of certain enhanced Google services, such as G
Suite Enterprise, G Suite Business, or G Suite for Education.

This is a generic function.
}
\examples{
\dontrun{
## specify the name
as_team_drive("abc")

## specify the id (substitute one of your own!)
as_team_drive(as_id("0AOPK1X2jaNckUk9PVA"))
}
}
