% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/team_drive_rm.R
\name{team_drive_rm}
\alias{team_drive_rm}
\title{Delete Team Drives}
\usage{
team_drive_rm(team_drive = NULL, verbose = TRUE)
}
\arguments{
\item{team_drive}{Anything that identifies the Team Drive(s) of interest. Can
be a character vector of names, a character vector of file ids or URLs
marked with \code{\link{as_id}()}, or a \code{\link{dribble}} consisting
only of Team Drives.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
Logical vector, indicating whether the delete succeeded.
}
\description{
Delete Team Drives

Note:
  \href{https://gsuite.google.com/learning-center/products/drive/get-started-team-drive/}{Team Drives}
  are only available to users of certain enhanced Google services, such as G
  Suite Enterprise, G Suite Business, or G Suite for Education.
}
\examples{
\dontrun{
## Create Team Drives to remove in various ways
team_drive_create("testdrive-01")
td02 <- team_drive_create("testdrive-02")
team_drive_create("testdrive-03")
td04 <- team_drive_create("testdrive-04")

## remove by name
team_drive_rm("testdrive-01")
## remove by id
team_drive_rm(as_id(td02))
## remove by URL (or, rather, id found in URL)
team_drive_rm(as_id("https://drive.google.com/drive/u/0/folders/Q5DqUk9PVA"))
## remove by dribble
team_drive_rm(td04)
}
}
\seealso{
Wraps the \code{teamdrives.delete} endpoint:
\itemize{
\item \url{https://developers.google.com/drive/v3/reference/teamdrives/delete}
}
}
