% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environments.R
\name{gtm_environments_delete}
\alias{gtm_environments_delete}
\title{Delete an environment}
\usage{
gtm_environments_delete(
  account_id,
  container_id,
  environment_id,
  force = c("TRUE", "FALSE")
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{environment_id}{Environment Id}

\item{force}{This will bypass the user confirmation. Useful for scripted functions to avoid user input}
}
\description{
This deletes a GTM environment
}
\examples{
\dontrun{
accountId <- 1234567
containerId <- 7654321
environmentId <- 3

gtm_environments_delete(accountId, containerId, environmentId, TRUE)

environmentId <- 4

gtm_environments_delete(accountId, containerId, environmentId)

#  This will delete environment 4 Are you sure you want to continue?"

#  1: Yes
#  2: No

# Selection: 1


# Environment 4 has been deleted.

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/environments/reauthorize}

Other environment functions: 
\code{\link{gtm_environments_create}()},
\code{\link{gtm_environments_get}()},
\code{\link{gtm_environments_list}()},
\code{\link{gtm_environments_reauthorize}()},
\code{\link{gtm_environments_update}()}
}
\concept{environment functions}
