% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{gce_push_registry}
\alias{gce_push_registry}
\title{Push to Google Container Registry}
\usage{
gce_push_registry(instance, save_name, container_name = NULL,
  image_name = NULL, container_url = "gcr.io",
  project = gce_get_global_project(), wait = FALSE)
}
\arguments{
\item{instance}{The VM to run within}

\item{save_name}{The new name for the saved image}

\item{container_name}{A running docker container. Can't be set if \code{image_name} is too.}

\item{image_name}{A docker image on the instance. Can't be set if \code{container_name} is too.}

\item{container_url}{The URL of where to save container}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}

This will only work on the Google Container optimised containers of image_family google_containers.
Otherwise you will need to get a container authentication yourself (for now)

It will start the push but it may take a long time to finish, especially the first time, 
  this function will return whilst waiting but don't turn off the VM until its finished.}

\item{wait}{Will wait for operation to finish on the instance if TRUE}
}
\value{
The tag the image was tagged with on GCE
}
\description{
Commit and save a running container or docker image to the Google Container Registry
}
\seealso{
Other container registry functions: \code{\link{gce_list_registry}},
  \code{\link{gce_pull_registry}},
  \code{\link{gce_tag_container}}
}
\concept{container registry functions}
