% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/googleAuthR_batch.R
\name{gar_batch_walk}
\alias{gar_batch_walk}
\title{Walk data through batches}
\usage{
gar_batch_walk(f, walk_vector, gar_pars = NULL, gar_paths = NULL,
  the_body = NULL, pars_walk = NULL, path_walk = NULL, body_walk = NULL,
  batch_size = 10, batch_function = NULL, data_frame_output = TRUE, ...)
}
\arguments{
\item{f}{a function from \code{\link{gar_api_generator}}}

\item{walk_vector}{a vector of the parameter or path to change}

\item{gar_pars}{a list of parameter arguments for f}

\item{gar_paths}{a list of path arguments for f}

\item{the_body}{a list of body arguments for f}

\item{pars_walk}{a character vector of the parameter(s) to modify for each walk of f}

\item{path_walk}{a character vector of the path(s) to modify for each walk of f}

\item{body_walk}{a character vector of the body(s) to modify for each walk of f}

\item{batch_size}{size of each request to Google /batch API}

\item{batch_function}{a function that will act on the result list of each batch API call}

\item{data_frame_output}{if the list of lists are dataframes, you can bind them all by setting to TRUE}

\item{...}{further arguments passed to the data parse function of f}
}
\value{
\strong{if data_frame_output is FALSE}: A list of lists.  
  Outer list the length of number of batches required, inner lists the results from the calls
  
  \strong{if data_frame_output is TRUE}: The list of lists will attempt to rbind all the results
}
\description{
Convienience function for walking through data in batches
}
\details{
You can modify more than one parameter or path arg, 
  but it must be the same walked vector e.g. \code{start = end = x}
  
Many Google APIs have \code{batch_size} limits greater than 10, 1000 is common.
}
\seealso{
Other batch functions: \code{\link{applyDataParseFunction}},
  \code{\link{doBatchRequest}}, \code{\link{gar_batch}},
  \code{\link{makeBatchRequest}},
  \code{\link{parseBatchResponse}}
}

