% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-modules.R
\name{segmentBuilder}
\alias{segmentBuilder}
\title{Create a GAv4 Segment Builder}
\usage{
segmentBuilder(input, output, session)
}
\arguments{
\item{input}{shiny input}

\item{output}{shiny output}

\item{session}{shiny session}
}
\value{
A segment definition
}
\description{
Shiny Module for use with \link{segmentBuilderUI}
}
\details{
Call via \code{shiny::callModule(segmentBuilder, "your_id")}
}
\examples{

\dontrun{

library(shiny)
library(googleAnalyticsR)

ui <- shinyUI(fluidPage(
               segmentBuilderUI("test1")
               ))
               
               
server <- shinyServer(function(input, output, session) {

segment <- callModule(segmentBuilder, "test1")

  .. use segment() in further gav4 calls.
  
})


# Run the application 
shinyApp(ui = ui, server = server)
}

}

