% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_to_haz.R
\name{prop_to_haz}
\alias{prop_to_haz}
\title{Estimate plausible piecewise constant hazard rates from summary
summary event proportions}
\usage{
prop_to_haz(probs, cutpoints = 0, endtime)
}
\arguments{
\item{probs}{vector. Probabilities of the event (i.e. cumulative incidence
probabilities) at one or more time point. If only a single value is given,
then it is assumed that this is the probability at the \code{endtime}.}

\item{cutpoints}{vector. Times at which the baseline hazard changes. Default
is \code{cutpoints = 0}, which corresponds to a simple (non-piecewise)
exponential model.}

\item{endtime}{scalar. Time at which final element in \code{probs}
corresponds to. Typically this would be the study endpoint time.}
}
\value{
Vector of constant hazard rates for each time piece defined by
\code{cutpoints}.
}
\description{
Given estimates of the event probability at one or more fixed
times, the corresponding piecewise hazard rates can be determined through
closed-form formulae. This utility function can be useful when simulating
trial datasets with plausible event rates.
}
\details{
Given \eqn{J-1} internal cut-points, then there are J intervals
defined as: \eqn{[s_0, s_1)}, \eqn{[s_1, s_2)}, \eqn{\dots}, \eqn{[s_{J-1},
  s_{J})}, with conditions that \eqn{s_0 = 0} and \eqn{s_J = \infty}. Each
interval corresponds to constant hazard \eqn{\lambda_j}.
}
\examples{
lambda <- prop_to_haz(0.15, endtime = 36) # 15\% probability at 36-months
all.equal(pexp(36, lambda), 0.15)

# 15\% probability at 12-months, and 30\% at 24-months
prop_to_haz(c(0.15, 0.30), c(0, 12), 24)
PWEALL::pwe(12, prop_to_haz(c(0.15, 0.30), c(0, 12), 24), c(0, 12))$dist
PWEALL::pwe(24, prop_to_haz(c(0.15, 0.30), c(0, 12), 24), c(0, 12))$dist
}
