% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_stats.R
\name{rankscore}
\alias{rankscore}
\title{compute rank^2 scores and rescale these between 0~1000 (with further precision captured by decimals)}
\usage{
rankscore(x, sort1, sort2, sort3, colname)
}
\arguments{
\item{x}{data.frame to sort (i.e. the genelist)}

\item{sort1}{numeric vector of length \code{nrow(x)} to sort by first/primarily (descending order, higher value gets better result score)}

\item{sort2}{numeric vector of length \code{nrow(x)} to sort by for breaking ties (descending order, higher value gets better result score)}

\item{sort3}{numeric vector of length \code{nrow(x)} to sort by for breaking ties (descending order, higher value gets better result score)}

\item{colname}{name for result column in \code{x}  (overwritten if already exists)}
}
\value{
data.frame \code{x} with added column \code{colname}, containing gene scores between 0 and 1000
}
\description{
rank^2 can yield huge values, e.g. a large genelist of N=50000 genes would imply max gene score = 50000^2 = 2.5e+09.
Thus we rescale these scores between 0~1000 so downstream applications (e.g. sum of 10000 gene scores) don't explode to huge numbers.
}
\examples{
  x = data.frame(gene=c(1, 2, 3, 4, 5),
                 pvalue=c(0.01, 1, 1, 0.1, 1),
                 effectsize=c(-2, 0.25, 0.5, 1, 0.25))
  print(x, row.names = FALSE)
  print(rankscore(x, sort1 = -1*x$pvalue, sort2 = abs(x$effectsize),
        sort3 = x$gene, colname="score") |>
    arrange(desc(score)), row.names = FALSE)
}
