% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_cov_cpp}
\alias{compute_cov_cpp}
\title{Computes the (MODWT) wavelet covariance matrix}
\usage{
compute_cov_cpp(signal_modwt, nb_level, compute_v = "diag", robust = TRUE,
  eff = 0.6)
}
\arguments{
\item{signal_modwt}{A \code{field<vec>} that contains the modwt decomposition.}

\item{nb_level}{A \code{integer} that contains the level of decomposition J.}

\item{compute_v}{A \code{string} that indicates what kind of matrix should be created. Possible options: "diag" or "none"}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}
}
\value{
A \code{field<mat>} containing the covariance matrix.
}
\description{
Calculates the (MODWT) wavelet covariance matrix
}
\examples{
\dontrun{
x=rnorm(100)
decomp = modwt(x)
V = compute_cov_cpp(decomp$data, decomp$nlevels, compute_v="diag", robust = TRUE, eff=0.6)
}
}
\keyword{internal}

