% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_comp.R
\name{split_comp}
\alias{split_comp}
\title{Split a mixture component of a Gaussian mixture model}
\usage{
split_comp(gmm, comp = 1, n_sub = 2, space = 0.5)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{comp}{An integer corresponding to the index of the split mixture
component.}

\item{n_sub}{A positive integer corresponding to the number of subcomponents.}

\item{space}{A numeric value in [0, 1[ corresponding to the space between the
subcomponents.}
}
\value{
The \code{gmm} object after splitting the mixture component.
}
\description{
This function splits a mixture component of a Gaussian mixture model using
the singular value decomposition of the covariance matrix (Zhang
\emph{et al.}, 2003).
}
\examples{
data(gmm_body)
gmm_1 <- split_comp(gmm_body, n_sub = 3)

}
\references{
Zhang, Z., Chen, C., Sun, J. and Chan, K. L. (2003). EM algorithms for
Gaussian mixtures with split-and-merge operation. \emph{Pattern Recognition},
36(9):1973--1983.
}
\seealso{
\code{\link{merge_comp}}
}
