% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{density}
\alias{density}
\title{Compute densities of a Gaussian mixture model}
\usage{
density(gmm, data, y = NULL, log = FALSE)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{data}{A data frame or numeric matrix containing the observations whose
densities are computed. Its columns must explicitly be named after the
variables of \code{gmm}.}

\item{y}{A character vector containing the dependent variables if conditional
densities are computed. If \code{NULL} (the default), joint densities are
computed.}

\item{log}{A logical value indicating whether the densities are returned as
log-densities.}
}
\value{
A numeric vector containing the (log-)densities.
}
\description{
This function computes densities of a Gaussian mixture model.
}
\examples{
data(gmm_body, data_body)
dens_1 <- density(gmm_body, data_body, log = TRUE)
dens_2 <- density(gmm_body, data_body, y = "WAIST", log = TRUE)

}
\seealso{
\code{\link{expectation}}, \code{\link{sampling}}
}
