% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm-auth.R
\name{gm_auth_configure}
\alias{gm_auth_configure}
\alias{gm_oauth_app}
\title{Edit auth configuration}
\usage{
gm_auth_configure(
  key = "",
  secret = "",
  path = Sys.getenv("GMAILR_APP"),
  appname = "gmailr",
  ...,
  app = httr::oauth_app(appname, key, secret, ...)
)

gm_oauth_app()
}
\arguments{
\item{key}{consumer key, also sometimes called the client ID}

\item{secret}{consumer secret, also sometimes called the client secret.}

\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{appname}{name of the application.  This is not used for OAuth, but is
used to make it easier to identify different applications.}

\item{...}{Additional arguments passed to \code{\link[httr:oauth_app]{httr::oauth_app()}}}

\item{app}{OAuth app, in the sense of \code{\link[httr:oauth_app]{httr::oauth_app()}}.}
}
\value{
\itemize{
\item \code{gm_auth_configure()}: An object of R6 class
\link[gargle:AuthState-class]{gargle::AuthState}, invisibly.
\item \code{gm_oauth_app()}: the current user-configured
\code{\link[httr:oauth_app]{httr::oauth_app()}}.
}
}
\description{
These functions give more control over and visibility into the auth
configuration than \code{\link[=gm_auth]{gm_auth()}} does. \code{gm_auth_configure()}
lets the user specify their own:
\itemize{
\item OAuth app, which is used when obtaining a user token.
See the vignette
\href{https://gargle.r-lib.org/articles/get-api-credentials.html}{How to get your own API credentials}
for more.
If the user does not configure these settings, internal defaults
are used.
\code{gm_oauth_app()} retrieves the currently configured OAuth app.
}
}
\examples{
\dontrun{
# see the current user-configured OAuth app (probaby `NULL`)
gm_oauth_app()

if (require(httr)) {

  # store current state, so we can restore
  original_app <- gm_oauth_app()

  # bring your own app via client id (aka key) and secret
  google_app <- httr::oauth_app(
    "my-awesome-google-api-wrapping-package",
    key = "123456789.apps.googleusercontent.com",
    secret = "abcdefghijklmnopqrstuvwxyz"
  )
  gm_auth_configure(app = google_app)

  # confirm current app
  gm_oauth_app()

  # restore original state
  gm_auth_configure(app = original_app)
  gm_oauth_app()
}

# bring your own app via JSON downloaded from Google Developers Console
gm_auth_configure(
  path = "/path/to/the/JSON/you/downloaded/from/google/dev/console.json"
)
}
}
\seealso{
Other auth functions: 
\code{\link{gm_deauth}()},
\code{\link{gm_scopes}()}
}
\concept{auth functions}
