\name{getProbNameGLPK}
\alias{getProbNameGLPK}
\alias{glp_get_prob_name}

\title{
  Retrieve Problem Name
}

\description{
  Low level interface function to the GLPK function \code{glp_get_prob_name}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  getProbNameGLPK(lp)
}

\arguments{
  \item{lp}{
    A pointer to a GLPK problem object.
  }
}

\details{
  Interface to the C function \code{getProbName} which calls the GLPK
  function \code{glp_get_prob_name}.
}

\value{
  The assigned name of the problem is returned.
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee.
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }

