\name{addColsGLPK}
\alias{addColsGLPK}
\alias{glp_add_cols}

\title{
  Add Columns to a GLPK Problem Object
}

\description{
  Low level interface function to the GLPK function \code{glp_add_cols}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  addColsGLPK(lp, ncols)
}

\arguments{
  \item{lp}{
    A pointer to a GLPK problem object.
  }
  \item{ncols}{
    The number of columns to add.
  }
}

\details{
  Interface to the C function \code{addCols} which calls the GLPK
  function \code{glp_add_cols}.
}

\value{
 The ordinal number of the first new column added to the
 problem object is returned.
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }

