% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottoclean.R
\name{glottoclean}
\alias{glottoclean}
\title{Clean glottodata}
\usage{
glottoclean(
  glottodata,
  structure = NULL,
  tona = NULL,
  tofalse = NULL,
  totrue = NULL
)
}
\arguments{
\item{glottodata}{glottodata (either a list or a data.frame)}

\item{structure}{Optional structure table (should be provided if glottodata doesn't contain any)}

\item{tona}{Optional additional values to recode to NA (besides default)}

\item{tofalse}{Optional additional values to recode to FALSE (besides default)}

\item{totrue}{Optional additional values to recode to TRUE (besides default)}
}
\value{
A cleaned-up version of the original glottodata object (either a list or a data.frame, depending on the input)
}
\description{
This function is a wrapper around glottorecode. This function has some built in default values that are being recoded.
For example, if column type is 'symm' or 'asymm', values such as "No" and 0 are recoded to FALSE and "?" is recoded to NA.
Use glottorecode directly if you don't want to use these defaults.
}
\examples{
glottodata <- glottoget("demodata", meta = TRUE)
glottodata <- glottoclean(glottodata)
}
