% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottosimplify.R
\name{glottosimplify}
\alias{glottosimplify}
\title{Simplify glottodata structures}
\usage{
glottosimplify(
  glottodata,
  droplist = TRUE,
  dropmeta = TRUE,
  dropspatial = TRUE,
  submerge = TRUE,
  dropunits = FALSE
)
}
\arguments{
\item{glottodata}{glottodata or glottosubdata.}

\item{droplist}{By default if glottodata is a list of tables, only the glottodata table is returned.}

\item{dropmeta}{By default all metadata is removed.}

\item{dropspatial}{By default spatial properties are removed.}

\item{submerge}{By default, glottosubdata tables are merged into a single glottodata table.}

\item{dropunits}{By default units are kept.}
}
\value{
a simplified version of the original dataset, either a data.frame/tibble or a list (depending on the selected options)
}
\description{
With glottosimplify, the structure of a glottodata object is simplified by removing tables and properties
}
\examples{
glottodata <- glottoget("demodata", meta = TRUE)
glottosimplify(glottodata)
}
