% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glossr-package.R
\name{set_style_options}
\alias{set_style_options}
\title{Set general styling options}
\usage{
set_style_options(styling = list())
}
\arguments{
\item{styling}{Named list of styling options for specific elements of glosses.}
}
\value{
Set the appropriate options.
}
\description{
This is a helper function to set \code{\link{options}} that control style characteristics
for glosses across the full document. It is called within \code{\link{use_glossr}}
but can be overridden later but setting the appropriate options.
}
\details{
There are two types of settings that can be provided in the list.
First, \code{trans_quotes} sets the characters that must surround the free translation in a gloss.
If no value is specified, it will be double quotes. There are no real restrictions
for this value.

Second, the following elements can set general styling instructions for different
sections of a gloss, formatting them completely in italics OR bold. The items with a \code{|}
indicate that various names are possible.
\describe{
  \item{source|preamble}{The line of the glosses where the \code{source} is rendered.}
  \item{a|first}{The first line of the glosses, with the original language text.}
  \item{b|second}{The second line of the glosses.}
  \item{c|third}{The third line of the glosses if it exists.}
  \item{ft|trans|translation}{The line of the glosses where the free \code{translation}
  is rendered.}
}
Each of these items can take one of a few values:
\itemize{
   \item \code{i}, \code{it}, \code{italics}, \code{textit} set italics.
   \item \code{b}, \code{bf}, \code{bold}, \code{textbf} set boldface.
}

#TODO create vignette
}
