% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalsOf.R
\name{globalsOf}
\alias{globalsOf}
\alias{findGlobals}
\title{Get all global objects of an expression}
\usage{
globalsOf(expr, envir = parent.frame(), ..., method = c("ordered",
  "conservative", "liberal"), tweak = NULL, substitute = FALSE,
  mustExist = TRUE, unlist = TRUE, recursive = TRUE)
}
\arguments{
\item{expr}{An R expression.}

\item{envir}{The environment from where to search for globals.}

\item{\dots}{Not used.}

\item{method}{A character string specifying what type of search algorithm to use.}

\item{tweak}{An optional function that takes an expression
and returns a tweaked expression.}

\item{substitute}{If TRUE, the expression is \code{substitute()}:ed,
otherwise not.}

\item{mustExist}{If TRUE, an error is thrown if the object of the
identified global cannot be located.  Otherwise, the global
is not returned.}

\item{unlist}{If TRUE, a list of unique objects is returned.
If FALSE, a list of \code{length(expr)} sublists.}

\item{recursive}{If TRUE, globals that are closures (functions) and that
exist outside of namespaces ("packages"), will be recursively
scanned for globals.}
}
\value{
A \link{Globals} object.
}
\description{
Get all global objects of an expression
}
\details{
There currently three methods for identifying global objects.

The \code{"ordered"} search method identifies globals such that
a global variable preceding a local variable with the same name
is not dropped (which the \code{"conservative"} method would).

The \code{"conservative"} search method tries to keep the number
of false positive to a minimum, i.e. the identified objects are
most likely true global objects.  At the same time, there is
a risk that some true globals are not identified (see example).
This search method returns the exact same result as the
\code{\link[codetools]{findGlobals}()} function of the
\pkg{codetools} package.

The \code{"liberal"} search method tries to keep the
true-positive ratio as high as possible, i.e. the true globals
are most likely among the identified ones.  At the same time,
there is a risk that some false positives are also identified.

With \code{recursive = TRUE}, globals part of locally defined
functions will also be found, otherwise not.
}
\examples{
b <- 2
expr <- substitute({ a <- b; b <- 1 })

## Will _not_ identify 'b' (because it's also a local)
globalsC <- globalsOf(expr, method="conservative")
print(globalsC)

## Will identify 'b'
globalsL <- globalsOf(expr, method="liberal")
print(globalsL)
}
\seealso{
Internally, the \pkg{\link{codetools}} package is utilized for
code inspections.
}
