% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{predict.glmgee}
\alias{predict.glmgee}
\title{Predictions for Generalized Estimating Equations}
\usage{
\method{predict}{glmgee}(
  object,
  ...,
  newdata,
  se.fit = FALSE,
  type = c("link", "response"),
  varest = c("robust", "df-adjusted", "model", "bias-corrected")
)
}
\arguments{
\item{object}{an object of the class \emph{glmgee}.}

\item{...}{further arguments passed to or from other methods.}

\item{newdata}{an (optional) \code{data frame} in which to look for variables with which to predict. If omitted, the fitted linear predictors are used.}

\item{se.fit}{an (optional) logical switch indicating if standard errors are required. As default, \code{se.fit} is set to FALSE.}

\item{type}{an (optional) character string giving the type of prediction required. The default, "link", is on the scale of the linear predictors, and the alternative, "response", is on the scale of the response variable.}

\item{varest}{an (optional) character string indicating the type of estimator which should be used to the variance-covariance matrix of the interest parameters. The available options are: robust sandwich-type estimator ("robust"), degrees-of-freedom-adjusted estimator ("df-adjusted"), bias-corrected estimator ("bias-corrected"), and the model-based or naive estimator ("model"). As default, \code{varest} is set to "robust".}
}
\value{
A matrix with so many rows as \code{newdata} and one column with the predictions. If \code{se.fit=}TRUE then a second column with estimates standard errors is included.
}
\description{
Produces predictions and optionally estimates standard errors of those predictions from a fitted generalized estimating equation.
}
\examples{
###### Example 1: Effect of ozone-enriched atmosphere on growth of sitka spruces
data(spruces)
mod1 <- size ~ poly(days,4) + treat
fit1 <- glmgee(mod1, id=tree, family=Gamma(log), data=spruces, corstr="AR-M-dependent")
newdata1 <- data.frame(days=c(556,556),treat=as.factor(c("normal","ozone-enriched")))
predict(fit1,newdata=newdata1,type="response",se.fit=TRUE)

###### Example 2: Treatment for severe postnatal depression
data(depression)
mod2 <- depressd ~ visit + group
fit2 <- glmgee(mod2, id=subj, family=binomial(logit), corstr="AR-M-dependent", data=depression)
newdata2 <- data.frame(visit=c(6,6),group=as.factor(c("placebo","oestrogen")))
predict(fit2,newdata=newdata2,type="response",se.fit=TRUE)

###### Example 3: Treatment for severe postnatal depression (2)
mod3 <- dep ~ visit*group
fit3 <- glmgee(mod3, id=subj, family=gaussian(identity), corstr="AR-M-dependent", data=depression)
newdata3 <- data.frame(visit=c(6,6),group=as.factor(c("placebo","oestrogen")))
predict(fit3,newdata=newdata3,type="response",se.fit=TRUE)

}
