% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ldh}
\alias{ldh}
\title{ldh}
\format{
A data frame with 448 rows and 5 variables:
\describe{
  \item{LDH}{a numeric vector indicating the proportion of lactic dehydrogenase enzyme leakage, a surrogate for cell toxicity.}
  \item{CCl4}{a numeric vector indicating the carbon tetrachloride at 0, 1, 2.5 and 5 mM.}
  \item{CHCl3}{a numeric vector indicating the chloroform at 0, 5, 10 and 25 mM.}
  \item{Flask}{a numeric vector indicating the flask of isolated hepatocyte suspensions.}
  \item{Time}{a numeric vector indicating the time at 0, 0.01, 0.25, 0.50, 1, 2 and 3 hours.}
}
}
\source{
Gennings, C., Chinchilli, V.M., Carter, W.H. (1989). Response
Surface Analysis with Correlated Data: A Nonlinear Model Approach.
\emph{Journal of the American Statistical Association}, 84, 805–809.
}
\usage{
data(ldh)
}
\description{
The data consists of the proportion of lactic dehydrogenase
enzyme leakage obtained as a response of hepatocyte cell toxicity to the
effects of different combinations of carbon tetrachloride (CCl4) and
chloroform (CHCl3). Thus, the main objective of the data analysis is to
evaluate the effects of CCl4, CHCl3 and their interactions on the
response.
}
\examples{
data(ldh)
opt <- unique(ldh$CCl4)
dev.new()
par(mfrow=c(1,length(opt)))
for(i in 1:length(opt))
boxplot(LDH ~ Time, data=subset(ldh,CCl4==opt[i]), ylim=c(0,0.8), main=paste("CCl4=",opt[i]))

dev.new()
opt <- unique(ldh$CHCl3)
par(mfrow=c(1,length(opt)))
for(i in 1:length(opt))
boxplot(LDH ~ Time, data=subset(ldh,CHCl3==opt[i]), ylim=c(0,0.8), main=paste("CHCl3=",opt[i]))

}
\references{
Vonesh E.F. (2012) Generalized Linear and Nonlinear Models
for Correlated Data: Theory and Applications Using SAS.
\emph{Cary, NC: SAS Institute Inc}.
}
\keyword{datasets}
