% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{dfbeta.zeroinflation}
\alias{dfbeta.zeroinflation}
\title{Dfbeta statistic for Regression Models to deal with Zero-Excess in Count Data}
\usage{
\method{dfbeta}{zeroinflation}(model, submodel = c("counts", "zeros"), coefs, identify, ...)
}
\arguments{
\item{model}{an object of class \emph{zeroinflation}.}

\item{submodel}{an (optional) character string which allows to specify the model: "counts" or "zeros". By default,
\code{submodel} is set to "counts".}

\item{coefs}{an (optional) character string which (partially) match with the names of some model parameters.}

\item{identify}{an (optional) integer indicating the number of individuals to identify on the plot of the Dfbeta statistic. This
is only appropriate if \code{coefs} is specified.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE} then \code{...} may be used
to include graphical parameters to customize the plot. For example, \code{col}, \code{pch}, \code{cex}, \code{main},
\code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix with so many rows as individuals in the sample and so many columns as parameters in the linear
predictor. The \eqn{i}-th row of that matrix corresponds to the difference between the estimates of the parameters
in the linear predictor using all individuals and the \emph{one-step approximation} of those estimates when the
\emph{i}-th individual is excluded from the dataset.
}
\description{
Produces an approximation, better known as the \emph{one-step approximation}, of the effect on the
parameter estimates of deleting each individual in turn. This function also can produce an index plot
of the Dfbeta statistic for some parameter chosen via the argument \code{coefs}.
}
\details{
The \emph{one-step approximation} of the estimates of the parameters when the \emph{i}-th individual
is excluded from the dataset consists of the vector obtained as result of the first iteration of the Newthon-Raphson
algorithm when it is performed using: (1) a dataset in which the \emph{i}-th individual is excluded; and (2)
a starting value which is the estimate of the same model but based on the dataset inluding all individuals.
}
\examples{
####### Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit <- zeroinf(infections ~ frequency + location, family="nb1(log)", data=swimmers)

dfbeta(fit, submodel="counts", coefs="frequency", col="red", lty=1, lwd=1,
       col.lab="blue", col.axis="blue", col.main="black", family="mono", cex=0.8)

dfbeta(fit, submodel="zeros", coefs="location", col="red", lty=1, lwd=1,
       col.lab="blue", col.axis="blue", col.main="black", family="mono", cex=0.8)

}
\references{
Pregibon D. (1981). Logistic regression diagnostics. \emph{The Annals of Statistics}, 9, 705-724.
}
