% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{adjR2.glm}
\alias{adjR2.glm}
\title{Adjusted R-squared in Generalized Linear Models}
\usage{
\method{adjR2}{glm}(..., digits = max(3, getOption("digits") - 2), verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class \emph{glm}, which are obtained from the fit of generalized linear models.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used. As default, \code{digits} is set to \code{max(3, getOption("digits") - 2)}.}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. As default, \code{verbose} is set to TRUE.}
}
\value{
a matrix with the following columns
\tabular{ll}{
\code{Deviance} \tab value of the residual deviance,\cr
\tab \cr
\code{R-squared} \tab value of the deviance-based R-squared,\cr
\tab \cr
\code{df}       \tab number of parameters in the linear predictor,\cr
\tab \cr
\code{adj.R-squared} \tab value of the adjusted deviance-based R-squared,\cr
}
}
\description{
Computes the adjusted deviance-based R-squared in generalized linear models.
}
\details{
The deviance-based R-squared is computed as \eqn{R^2=1 - Deviance/Null.Deviance}. Then,
the adjusted deviance-based R-squared is computed as
\eqn{1 - \frac{n-1}{n-p}(1-R^2)}, where \eqn{p} is the
number of parameters in the linear predictor and \eqn{n} is the sample size.
}
\examples{
###### Example 1: Fuel efficiency of cars
Auto <- ISLR::Auto
fit1 <- glm(mpg ~ horsepower*weight, family=Gamma(inverse), data=Auto)
fit2 <- update(fit1, formula=mpg ~ horsepower*weight*cylinders)
fit3 <- update(fit1, family=Gamma(log))
fit4 <- update(fit2, family=Gamma(log))
fit5 <- update(fit1, family=inverse.gaussian(log))
fit6 <- update(fit2, family=inverse.gaussian(log))

AIC(fit1,fit2,fit3,fit4,fit5,fit6)
BIC(fit1,fit2,fit3,fit4,fit5,fit6)
adjR2(fit1,fit2,fit3,fit4,fit5,fit6)

}
