% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xgbm_tuned_230606.R
\name{xgb.tuned}
\alias{xgb.tuned}
\title{Get a tuned XGBoost model fit}
\usage{
xgb.tuned(
  train.xgb.dat,
  booster = "gbtree",
  objective = "survival:cox",
  eval_metric = NULL,
  folds_xgb = 5,
  minimize = NULL,
  nrounds = 1000
)
}
\arguments{
\item{train.xgb.dat}{The data to be used for training the XGBoost model}

\item{booster}{for now just "gbtree" (default)}

\item{objective}{one of "survival:cox" (default), "binary:logistic" or "reg:squarederror"}

\item{eval_metric}{one of "cox-nloglik" (default), "auc" or "rmse",}

\item{folds_xgb}{number of folds used in xgb.cv() call}

\item{minimize}{whether the eval_metiric is to be minimized or maximized}

\item{nrounds}{max number of iterations}
}
\value{
an XGBoost model fit
}
\description{
This fits a gradient boosting machine model using the XGBoost
platform.  It uses the mlrMBO mlrMBO package to search for a well fitting set of 
hyperparameters and will generally provide a better fit than xgb.simple(). 
Both this program and xgb.simple() require data to be provided in a 
xgb.DMatrix() object.  This object can be constructed with a command like 
data.full <- xgb.DMatrix( data=myxs, label=mylabel), where myxs object contains the 
predictors (features) in a numerical matrix format with no missing 
values, and mylabel is the outcome or dependent variable.  For logistic regression
this would typically be a vector of 0's and 1's.  For linear regression this would be 
vector of numerical values. For a Cox proportional hazards model this would be 
in a format required for XGBoost, which is different than for the survival package 
or glmnet package.  For the Cox model a vector is used where observations 
associated with an event are assigned the time of event, and observations 
associated with censoring are assigned the NEGATIVE of the time of censoring.  In    
this way information about time and status are communicated in a single vector
instead of two vectors.  The xgb.tuned() function does not handle (start,stop) 
time, i.e. interval, data.  To tune the xgboost model we use the mlrMBO package
which "suggests" the DiceKriging and rgenoud packages, but doe not install 
these.  Still, for xgb.tuned() to run it seems that one should install the 
DiceKriging and rgenoud packages.
}
\examples{
\donttest{
# Simulate some data for a Cox model 
sim.data=glmnetr.simdata(nrows=1000, ncols=100, beta=NULL)
Surv.xgb = ifelse( sim.data$event==1, sim.data$yt, -sim.data$yt )
data.full <- xgboost::xgb.DMatrix(data = sim.data$xs, label = Surv.xgb)
# for this example we use a small number for folds_n and nrounds to shorten 
# run time.  This may still take a minute or so.  
# xgbfit=xgb.tuned(data.full,objective="survival:cox",folds_xgb=5,nrounds=20)
# preds = predict(xgbfit, sim.data$xs)
# summary( preds ) 
}

}
\author{
Walter K Kremers with contributions from Nicholas B Larson
}
