% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{inForm}
\alias{inForm}
\alias{extractForm}
\alias{dropHead}
\alias{drop.special2}
\title{test formula: does it contain a particular element?}
\usage{
inForm(form, value)

extractForm(term, value)

dropHead(term, value)

drop.special2(x, value = quote(offset), preserve = NULL)
}
\arguments{
\item{value}{head of terms to extract}

\item{term}{expression/formula}

\item{x}{formula}

\item{preserve}{(integer) retain the specified occurrence of "value"}

\item{value}{term to remove from formula}
}
\value{
a list of expressions
}
\description{
test formula: does it contain a particular element?

extract terms with a given head from an expression/formula

return a formula/expression with a given value stripped, where
it occurs as the head of a term

drop terms matching a particular value from an expression
}
\examples{
inForm(z~.,quote(.))
inForm(z~y,quote(.))
inForm(z~a+b+c,quote(c))
inForm(z~a+b+(d+e),quote(c))
f <- ~ a + offset(x)
f2 <- z ~ a
inForm(f,quote(offset))
inForm(f2,quote(offset))
extractForm(~a+offset(b),quote(offset))
extractForm(~c,quote(offset))
extractForm(~a+offset(b)+offset(c),quote(offset))
dropHead(~a+offset(b),quote(offset))
dropHead(~a+poly(x+z,3)+offset(b),quote(offset))
}
\keyword{internal}
