\name{gjamIIEplot}
\alias{gjamIIEplot}
\title{Plots indirect effects and interactions for gjam data}
\description{
  Using the object returned by \code{\link{gjamIIEplot}} generates a plot for a response variable.
}
\usage{
  gjamIIEplot(fit, response, effectMu, effectSd = NULL, 
              ylim = NULL, col='black', legLoc = 'topleft', cex = 1)
}
\arguments{
  \item{fit}{object from \code{gjamIIE}.}

  \item{response}{name of a column in fit$y to plot.}

  \item{effectMu}{character vector of mean effects to plot, can include \code{'main','int','direct','ind'}.}

  \item{effectSd}{character vector can include all or some of \code{effectMu}.}
  
  \item{ylim}{vector of two values defines vertical axis range.}
 
  \item{col}{vector of colors for barplot.}
  
  \item{legLoc}{character for legend location.}
  
  \item{cex}{font size.}
}
\details{
For plotting direct effects, interactions, and indirect effects from an object \code{fit} generated by \code{gjamIIE}.  The character vector supplied as \code{effectMu} can include main effects (\code{'main'}), interactions (\code{'int'}), main effects plus interactions (\code{'direct'}), and/or indirect effects (\code{'ind'}).  The list \code{effectSd} draws 0.95 predictive intervals for all or some of the effects listed in \code{effectM}u.  Bars are contributions of each effect to the \code{response}.

For factors, effects are plotted relative to the mean over all factor levels.
}
\examples{
\dontrun{
sim <- gjamSimData(S = 10, Q = 6, typeNames = 'OC')
ml  <- list(ng = 50, burnin = 5, typeNames = sim$typeNames)
out <- gjam(sim$formula, sim$xdata, sim$ydata, modelList = ml)

xvector <- colMeans(out$inputs$xStand)  #predict at mean values for data, standardized x
xvector[1] <- 1

fit <- gjamIIE(out, xvector)

gjamIIEplot(fit, response = 'S1', effectMu = c('main','ind'), 
            effectSd = c('main','ind'), legLoc = 'topleft')
}
}
\author{
James S Clark, \email{jimclark@duke.edu}
}
\references{
Clark, J.S., D. Nemergut, B. Seyednasrollah, P. Turner, and S. Zhang. 2017.  Generalized joint attribute modeling for biodiversity analysis: Median-zero, multivariate, multifarious data.  Ecological Monographs 87, 34-56.
}
\seealso{
\code{\link{gjamIIE}} generates output for \code{gjamIIEplot}

A more detailed vignette is can be obtained with:

\code{browseVignettes('gjam')}

web site 'http://sites.nicholas.duke.edu/clarklab/code/'.
}

