% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_commits.R
\name{get_commits_tags}
\alias{get_commits_tags}
\title{Get commits associated chronologically with tags}
\usage{
get_commits_tags(repo = ".", ref = "master", path = NULL, silent = FALSE)
}
\arguments{
\item{repo}{a path to a repository or a \code{git_repository}
object. Default is '.'}

\item{ref}{The name of a reference to list commits from e.g. a tag
or a branch. The default is NULL for the current branch.}

\item{path}{The path to a file. If not NULL, only commits modifying
this file will be returned. Note that modifying commits that
occurred before the file was given its present name are not
returned; that is, the output of \code{git log} with
\code{--no-follow} is reproduced.}

\item{silent}{Logical. Whether to hide messages.}
}
\value{
A tibble with one line for each commit and the following columns:
\itemize{
\item sha: sha of the commit
\item summary: First line of the commit message
\item message: Full content of the commit message
\item author: author of the commit
\item email: email of the author
\item when: commit time
\item order: order of commit messages. 1 is the oldest.
\item tag.name: name of tag associated with all commits since the last tag
\item tag.message: message of the tagged commit
}
}
\description{
Get commits associated chronologically with tags
}
\examples{
repo <- fake_repo()
get_commits_tags(repo = repo)
}
