% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/branch.r
\docType{methods}
\name{show,git_branch-method}
\alias{show,git_branch-method}
\alias{show,git_branch-methods}
\title{Brief summary of branch}
\usage{
\S4method{show}{git_branch}(object)
}
\arguments{
\item{object}{The branch \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of branch
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user and commit a file
config(repo, user.name="Alice", user.email="alice@example.org")
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of the branch in the repository
branches(repo)[[1]]
}
}
\keyword{methods}

