% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.r
\docType{methods}
\name{tag}
\alias{tag}
\alias{tag,git_repository-method}
\title{Create tag targeting HEAD commit in repository}
\usage{
tag(object, name, message, session = FALSE,
  tagger = default_signature(object))

\S4method{tag}{git_repository}(object, name, message, session = FALSE,
  tagger = default_signature(object))
}
\arguments{
\item{object}{The repository \code{object}.}

\item{name}{Name for the tag.}

\item{message}{The tag message.}

\item{session}{Add sessionInfo to tag message. Default is FALSE.}

\item{tagger}{The tagger (author) of the tag}
}
\value{
invisible(\code{git_tag}) object
}
\description{
Create tag targeting HEAD commit in repository
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Create tag
tag(repo, "Tagname", "Tag message")

## List tags
tags(repo)
}
}
\keyword{methods}

