% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_attributions.R
\name{gisco_attributions}
\alias{gisco_attributions}
\title{Attribution when publishing GISCO data}
\usage{
gisco_attributions(lang = "en", copyright = FALSE)
}
\arguments{
\item{lang}{Language (two-letter ISO code). See
\url{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes} and Details.}

\item{copyright}{Boolean. Whether to display the copyright notice or not on the console.}
}
\value{
A string with the attribution to be used.
}
\description{
Get the legal text to be used along with the data downloaded with this
package
}
\details{
Current languages supported are:
\itemize{
\item \code{"en"} - English
\item \code{"da"} - Danish
\item \code{"de"} - German
\item \code{"es"} - Spanish
\item \code{"fi"} - Finish
\item \code{"fr"} - French
\item \code{"no"} - Norwegian
\item \code{"sv"} - Swedish
}

Please consider
\href{https://github.com/rOpenGov/giscoR/issues}{contributing} if you spot any
mistake or want to add a new language.
}
\note{
COPYRIGHT NOTICE

When data downloaded from GISCO is used in any printed or electronic
publication, in addition to any other provisions applicable to the whole
Eurostat website, data source will have to be acknowledged in the legend of
the map and in the introductory page of the publication with the following
copyright notice:
\itemize{
\item EN: (C) EuroGeographics for the administrative boundaries
\item FR: (C) EuroGeographics pour les limites administratives
\item DE: (C) EuroGeographics bezuglich der Verwaltungsgrenzen
}

For publications in languages other than English, French or German,
the translation of the copyright notice in the language of the publication
shall be used.

If you intend to use the data commercially, please contact EuroGeographics
for information regarding their licence agreements.
}
\examples{
gisco_attributions()

gisco_attributions(lang = "es", copyright = TRUE)

gisco_attributions(lang = "XXX")
}
\seealso{
Other helper: 
\code{\link{gisco_check_access}()}
}
\concept{helper}
