% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-gi.R
\name{plot_rank_scatter}
\alias{plot_rank_scatter}
\title{Rank plot for target-level GI scores}
\usage{
plot_rank_scatter(gimap_dataset, reps_to_drop = "")
}
\arguments{
\item{gimap_dataset}{A special dataset structure that is originally setup using `setup_data()` and has had gi scores calculated with `calc_gi()`.}

\item{reps_to_drop}{Names of replicates that should be not plotted (Optional)}
}
\value{
A ggplot2 rankplot of the target level genetic interaction scores.
}
\description{
This plot is meant to be functionally equivalent to Fig 5a (for HeLa, equivalent of Fig 3c for PC9).
Rank plot of target-level GI scores.
Dashed horizontal lines are for GI scores of 0.25 and -0.5
}
\examples{
\donttest{

gimap_dataset <- get_example_data("gimap") \%>\%
  gimap_filter() \%>\%
  gimap_annotate(cell_line = "HELA") \%>\%
  gimap_normalize(
    timepoints = "day"
  ) \%>\%
  calc_gi()

# To plot results
plot_exp_v_obs_scatter(gimap_dataset)
plot_rank_scatter(gimap_dataset)
plot_volcano(gimap_dataset)
}
}
