% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-text-viewport.R
\docType{data}
\name{geom_text_viewport}
\alias{GeomTextViewport}
\alias{geom_text_viewport}
\title{Draw Text at Relative Position on Viewport}
\usage{
geom_text_viewport(mapping = NULL, data = NULL, stat = "identity",
  position = "identity", ..., hjust = "inward", vjust = "inward",
  parse = FALSE, check_overlap = FALSE, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{hjust}{horizontal justification}

\item{vjust}{vertical justification}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
Since it is sometimes counter intuitive for working with ternary or other non-cartesian coordinates in the 
event that the the user wishes to place a text-geometry based on visual inspection, this geometry 
positions such text item at a fraction from x=[0,1] and y=[0,1] of the viewport in x and y cartesian 
coordinates.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom","Text")}
}
\examples{
library(ggplot2)
data(Feldspar)
base = ggtern(data=Feldspar,aes(Ab,An,Or)) + 
  geom_mask() + 
  geom_point() + 
  geom_text_viewport(x=0.5,y=0.5,label="Middle",color='red') + 
  geom_text_viewport(x=1.0,y=1.0,label="Top Right",color='blue') + 
  geom_text_viewport(x=0.0,y=0.0,label="Bottom Left",color='green') +
  geom_text_viewport(x=0.0,y=1.0,label="Top Left",color='orange') + 
  geom_text_viewport(x=1.0,y=0.0,label="Bottom Right",color='magenta')
base

base + 
  geom_text_viewport(x=0.9,y=0.5,label="Clipping Turned Off",color='purple',hjust=0,clip='on') 

base + 
  geom_text_viewport(x=0.9,y=0.5,label="Clipping Turned Off",color='purple',hjust=0,clip='off') 

}
\author{
Nicholas Hamilton
}
\seealso{
\code{\link[ggplot2]{geom_text}}
}
\keyword{datasets}

