% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme-defaults.R
\name{ggtern_themes}
\alias{ggtern_themes}
\alias{theme_bw}
\alias{theme_classic}
\alias{theme_custom}
\alias{theme_dark}
\alias{theme_darker}
\alias{theme_gray}
\alias{theme_grey}
\alias{theme_light}
\alias{theme_linedraw}
\alias{theme_minimal}
\alias{theme_rgbg}
\alias{theme_rgbw}
\alias{theme_tern_bw}
\alias{theme_tern_classic}
\alias{theme_tern_gray}
\alias{theme_tern_grey}
\alias{theme_tern_minimal}
\alias{theme_tern_rgbg}
\alias{theme_tern_rgbw}
\alias{theme_void}
\title{ggtern themes}
\usage{
theme_gray(base_size = 12, base_family = "")

theme_bw(base_size = 12, base_family = "")

theme_linedraw(base_size = 12, base_family = "")

theme_classic(base_size = 12, base_family = "")

theme_void(base_size = 12, base_family = "")

theme_rgbg(base_size = 12, base_family = "")

theme_rgbw(base_size = 12, base_family = "")

theme_minimal(base_size = 12, base_family = "")

theme_dark(base_size = 12, base_family = "")

theme_darker(base_size = 12, base_family = "")

theme_light(base_size = 12, base_family = "")

theme_custom(base_size = 12, base_family = "",
  tern.plot.background = "grey92", tern.panel.background = "white",
  col.T = "gray95", col.L = "gray95", col.R = "gray95",
  col.BG = "transparent", col.grid.minor = "gray90")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{tern.plot.background}{colour of background colour to plot area}

\item{tern.panel.background}{colour of panel background of plot area}

\item{col.T}{colour of top axis, ticks labels and major gridlines}

\item{col.L}{colour of left axis, ticks, labels and major gridlines}

\item{col.R}{colour of right axis, ticks, labels and major gridlines}

\item{col.BG}{colour of the plot background area}

\item{col.grid.minor}{the colour of the minor grid
\code{theme_custom} is a convenience function to allow the user to control the basic theme colours very easily.}
}
\description{
Themes set the general aspect of the plot such as the colour of the
background, gridlines, the size and colour of fonts.

\code{theme_rgbg} is a theme with grey background, red, green and blue axes and gridlines
}
\details{
\describe{

\item{\code{theme_gray}}{
The signature ggplot2 theme with a grey background and white gridlines,
designed to put the data forward yet make comparisons easy.}

\item{\code{theme_bw}}{
The classic dark-on-light ggplot2 theme. May work better for presentations
displayed with a projector.}

\item{\code{theme_linedraw}}{
A theme with only black lines of various widths on white backgrounds,
reminiscent of a line drawings. Serves a purpose similar to \code{theme_bw}.
Note that this theme has some very thin lines (<< 1 pt) which some journals
may refuse.}

\item{\code{theme_light}}{
A theme similar to \code{theme_linedraw} but with light grey lines and axes,
to direct more attention towards the data.}

\item{\code{theme_dark}}{
The dark cousin of \code{theme_light}, with similar line sizes but a dark background. 
Useful to make thin coloured lines pop out.
}

\item{\code{theme_darker}}{
A darker cousing to \code{theme_dark}, with a dark panel background.
}

\item{\code{theme_minimal}}{
A minimalistic theme with no background annotations.
}

\item{\code{theme_classic}}{
A classic-looking theme, with x and y axis lines and no gridlines.
}

\item{\code{theme_rgbw}}{
 A theme with white background, red, green and blue axes and gridlines
}

\item{\code{theme_rgbg}}{
A theme with grey background, red, green and blue axes and gridlines
}

\item{\code{theme_void}}{ 
A completely empty theme.
}

\item{\code{theme_custom}}{
Theme with custom basic colours
}
}
}
\examples{
data(Feldspar)
p <- ggtern(Feldspar,aes(Ab,An,Or)) + 
     geom_point(aes(colour=T.C,size=P.Gpa)) + 
     facet_wrap(~Feldspar)

#Uncomment to run
p + theme_gray()
p + theme_rgbg()
p + theme_dark()
}

