% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geom-confidence.R
\name{geom_confidence}
\alias{GeomConfidence}
\alias{StatConfidence}
\alias{geom_confidence}
\title{Confidence Interval}
\usage{
geom_confidence(mapping = NULL, data = NULL, breaks = c(0.5, 0.9, 0.95),
  n = 500, stat = "confidence", position = "identity", na.rm = FALSE,
  ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{breaks}{the confidence intervals, default to 50, 90 and 95 percent.}

\item{n}{the numer of points in the approximation for each confidence interval.}

\item{stat}{The statistical transformation to use on the data for this
layer.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Calculates the confidence intervals, via the Mahalnobis Distance and use of the \code{\link[=logratio]{Log-Ratio Transformation}}.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "Confidence")}
}
\examples{
data(Feldspar)
  ggtern(data=Feldspar,aes(An,Ab,Or)) + geom_point() + geom_confidence()
}

