% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/geom-density-tern.R
\name{geom_density_tern}
\alias{DensityTern}
\alias{GeomDensityTern}
\alias{geom_density_tern}
\title{Contours from a 2d density estimate - (ggtern version)}
\usage{
geom_density_tern(mapping = NULL, data = NULL, stat = "DensityTern",
  position = "identity", lineend = "butt", linejoin = "round",
  linemitre = 1, na.rm = FALSE, n = getOption("tern.mesh.size"),
  buffer = getOption("tern.mesh.buffer"), ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this
layer.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{lineend}{Line end style (round, butt, square)}

\item{linejoin}{Line join style (round, mitre, bevel)}

\item{linemitre}{Line mitre limit (number greater than 1)}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{n}{Number of grid points in each direction of the mesh. Can be scalar or a length-2 integer vector.}

\item{buffer}{factor to buffer the mesh, to prevent ugly truncation of contours, 1.0 means no buffering}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
Perform a 2D kernel density estimatation using kde2d and display the
results with contours.
}
\details{
This can be useful for dealing with overplotting. Additional weight aesthetic (see aesthetic section below) permits better weighting if desired
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggtern:::rd_aesthetics("geom", "DensityTern")}
}

