% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggbetweenstats.R
\name{ggbetweenstats}
\alias{ggbetweenstats}
\title{Box/Violin plots for group or condition comparisons in
between-subjects designs.}
\usage{
ggbetweenstats(
  data,
  x,
  y,
  plot.type = "boxviolin",
  type = "parametric",
  pairwise.comparisons = TRUE,
  pairwise.display = "significant",
  p.adjust.method = "holm",
  effsize.type = "unbiased",
  bf.prior = 0.707,
  bf.message = TRUE,
  results.subtitle = TRUE,
  xlab = NULL,
  ylab = NULL,
  caption = NULL,
  title = NULL,
  subtitle = NULL,
  k = 2L,
  var.equal = FALSE,
  conf.level = 0.95,
  nboot = 100L,
  tr = 0.2,
  centrality.plotting = TRUE,
  centrality.type = type,
  centrality.point.args = list(size = 5, color = "darkred"),
  centrality.label.args = list(size = 3, nudge_x = 0.4, segment.linetype = 4),
  outlier.tagging = FALSE,
  outlier.label = NULL,
  outlier.coef = 1.5,
  outlier.shape = 19,
  outlier.color = "black",
  outlier.label.args = list(size = 3),
  point.args = list(position = ggplot2::position_jitterdodge(dodge.width = 0.6), alpha
    = 0.4, size = 3, stroke = 0),
  violin.args = list(width = 0.5, alpha = 0.2),
  ggsignif.args = list(textsize = 3, tip_length = 0.01),
  ggtheme = ggplot2::theme_bw(),
  ggstatsplot.layer = TRUE,
  package = "RColorBrewer",
  palette = "Dark2",
  ggplot.component = NULL,
  output = "plot",
  ...
)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. Other data types (e.g., matrix,table, array, etc.) will \strong{not}
be accepted.}

\item{x}{The grouping (or independent) variable from the dataframe \code{data}.}

\item{y}{The response (or outcome or dependent) variable from the
dataframe \code{data}.}

\item{plot.type}{Character describing the \emph{type} of plot. Currently supported
plots are \code{"box"} (for only boxplots), \code{"violin"} (for only violin plots),
and \code{"boxviolin"} (for a combination of box and violin plots; default).}

\item{type}{A character specifying the type of statistical approach.
Four possible options:

\itemize{
\item \code{"parametric"}
\item \code{"nonparametric"}
\item \code{"robust"}
\item \code{"bayes"}
}

Corresponding abbreviations are also accepted: \code{"p"} (for parametric),
\code{"np"} (for nonparametric), \code{"r"} (for robust), or \code{"bf"} (for Bayesian).}

\item{pairwise.comparisons}{Logical that decides whether pairwise comparisons
are to be displayed (default: \code{TRUE}). Please note that only
\strong{significant} comparisons will be shown by default. To change this
behavior, select appropriate option with \code{pairwise.display} argument. The
pairwise comparison dataframes are prepared using the
\code{pairwiseComparisons::pairwise_comparisons} function. For more details
about pairwise comparisons, see the documentation for that function.}

\item{pairwise.display}{Decides \emph{which} pairwise comparisons to display.
Available options are:
\itemize{
\item \code{"significant"} (abbreviation accepted: \code{"s"})
\item \code{"non-significant"} (abbreviation accepted: \code{"ns"})
\item \code{"all"}
}

You can use this argument to make sure that your plot is not uber-cluttered
when you have multiple groups being compared and scores of pairwise
comparisons being displayed.}

\item{p.adjust.method}{Adjustment method for \emph{p}-values for multiple
comparisons. Possible methods are: \code{"holm"} (default), \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{bf.message}{Logical that decides whether to display Bayes Factor in
favor of the \emph{null} hypothesis. This argument is relevant only \strong{for
parametric test} (Default: \code{TRUE}).}

\item{results.subtitle}{Decides whether the results of statistical tests are
to be displayed as a subtitle (Default: \code{TRUE}). If set to \code{FALSE}, only
the plot will be returned.}

\item{xlab, ylab}{Labels for \code{x} and \code{y} axis variables. If \code{NULL} (default),
variable names for \code{x} and \code{y} will be used.}

\item{caption}{The text for the plot caption.}

\item{title}{The text for the plot title.}

\item{subtitle}{The text for the plot subtitle. Will work only if
\code{results.subtitle = FALSE}.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2L}).}

\item{var.equal}{a logical variable indicating whether to treat the
    two variances as being equal. If \code{TRUE} then the pooled
    variance is used to estimate the variance otherwise the Welch
    (or Satterthwaite) approximation to the degrees of freedom is used.}

\item{conf.level}{Scalar between \code{0} and \code{1}. If unspecified, the defaults
return \verb{95\%} confidence/credible intervals (\code{0.95}).}

\item{nboot}{Number of bootstrap samples for computing confidence interval
for the effect size (Default: \code{100}).}

\item{tr}{Trim level for the mean when carrying out \code{robust} tests. In case
of an error, try reducing the value of \code{tr}, which is by default set to
\code{0.2}. Lowering the value might help.}

\item{centrality.plotting}{Logical that decides whether centrality tendency
measure is to be displayed as a point with a label (Default: \code{TRUE}).
Function decides which central tendency measure to show depending on the
\code{type} argument.
\itemize{
\item \strong{mean} for parametric statistics
\item \strong{median} for non-parametric statistics
\item \strong{trimmed mean} for robust statistics
\item \strong{MAP estimator} for Bayesian statistics
}

If you want default centrality parameter, you can specify this using
\code{centrality.type} argument.}

\item{centrality.type}{Decides which centrality parameter is to be displayed.
The default is to choose the same as \code{type} argument. You can specify this
to be:
\itemize{
\item \code{"parameteric"} (for \strong{mean})
\item \code{"nonparametric"} (for \strong{median})
\item \code{robust} (for \strong{trimmed mean})
\item \code{bayes} (for \strong{MAP estimator})
}

Just as \code{type} argument, abbreviations are also accepted.}

\item{centrality.point.args, centrality.label.args}{A list of additional aesthetic
arguments to be passed to \code{ggplot2::geom_point} and
\code{ggrepel::geom_label_repel} geoms, which are involved in mean plotting.}

\item{outlier.tagging}{Decides whether outliers should be tagged (Default:
\code{FALSE}).}

\item{outlier.label}{Label to put on the outliers that have been tagged. This
\strong{can't} be the same as \code{x} argument.}

\item{outlier.coef}{Coefficient for outlier detection using Tukey's method.
With Tukey's method, outliers are below (1st Quartile) or above (3rd
Quartile) \code{outlier.coef} times the Inter-Quartile Range (IQR) (Default:
\code{1.5}).}

\item{outlier.shape}{Hiding the outliers can be achieved by setting
\code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the \code{y}-axis will be
the same with outliers shown and outliers hidden.}

\item{outlier.color}{Default aesthetics for outliers (Default: \code{"black"}).}

\item{outlier.label.args}{A list of additional aesthetic arguments to be
passed to \code{ggrepel::geom_label_repel} for outlier label plotting.}

\item{point.args}{A list of additional aesthetic arguments to be passed to
the \code{geom_point} displaying the raw data.}

\item{violin.args}{A list of additional aesthetic arguments to be passed to
the \code{geom_violin}.}

\item{ggsignif.args}{A list of additional aesthetic
arguments to be passed to \code{ggsignif::geom_signif}.}

\item{ggtheme}{A function, \code{ggplot2} theme name. Default value is
\code{ggplot2::theme_bw()}. Any of the \code{ggplot2} themes, or themes from
extension packages are allowed (e.g., \code{ggthemes::theme_fivethirtyeight()},
\code{hrbrthemes::theme_ipsum_ps()}, etc.).}

\item{ggstatsplot.layer}{Logical that decides whether \code{theme_ggstatsplot}
theme elements are to be displayed along with the selected \code{ggtheme}
(Default: \code{TRUE}). \code{theme_ggstatsplot} is an opinionated theme layer that
override some aspects of the selected \code{ggtheme}.}

\item{package, palette}{Name of the package from which the given palette is to
be extracted. The available palettes and packages can be checked by running
\code{View(paletteer::palettes_d_names)}.}

\item{ggplot.component}{A \code{ggplot} component to be added to the plot prepared
by \code{ggstatsplot}. This argument is primarily helpful for \code{grouped_}
variants of all primary functions. Default is \code{NULL}. The argument should
be entered as a \code{ggplot2} function or a list of \code{ggplot2} functions.}

\item{output}{Character that describes what is to be returned: can be
\code{"plot"} (default) or \code{"subtitle"} or \code{"caption"}. Setting this to
\code{"subtitle"} will return the expression containing statistical results. If
you have set \code{results.subtitle = FALSE}, then this will return a \code{NULL}.
Setting this to \code{"caption"} will return the expression containing details
about Bayes Factor analysis, but valid only when \code{type = "parametric"} and
\code{bf.message = TRUE}, otherwise this will return a \code{NULL}.}

\item{...}{Currently ignored.}
}
\description{
\Sexpr[results=rd, stage=render]{rlang:::lifecycle("maturing")}

A combination of box and violin plots along with jittered data points for
between-subjects designs with statistical details included in the plot as a
subtitle.
}
\examples{
\donttest{
# to get reproducible results from bootstrapping
set.seed(123)
library(ggstatsplot)

# simple function call with the defaults
ggstatsplot::ggbetweenstats(
  data = mtcars,
  x = am,
  y = mpg,
  title = "Fuel efficiency by type of car transmission",
  caption = "Transmission (0 = automatic, 1 = manual)"
)

# more detailed function call
ggstatsplot::ggbetweenstats(
  data = datasets::morley,
  x = Expt,
  y = Speed,
  type = "nonparametric",
  plot.type = "box",
  xlab = "The experiment number",
  ylab = "Speed-of-light measurement",
  pairwise.comparisons = TRUE,
  p.adjust.method = "fdr",
  outlier.tagging = TRUE,
  outlier.label = Run,
  ggtheme = ggplot2::theme_grey(),
  ggstatsplot.layer = FALSE
)
}
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/ggbetweenstats.html}
}
\seealso{
\code{\link{grouped_ggbetweenstats}}, \code{\link{ggwithinstats}},
\code{\link{grouped_ggwithinstats}}
}
