% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_theme_ggstatsplot.R
\name{ggplot_converter}
\alias{ggplot_converter}
\title{Transform object of any other class to an object of class \code{ggplot}.}
\usage{
ggplot_converter(plot)
}
\arguments{
\item{plot}{A plot that needs to be converted to object of class \code{ggplot}.}
}
\description{
Transform object of any other class to an object of class \code{ggplot}.
}
\examples{
library(ggplot2)

# creating a plot that is not of class `ggplot`
p <- ggExtra::ggMarginal(ggplot(mtcars, aes(wt, mpg)) + geom_point())

# checking class of object
class(p)

# checking class of converted plot
p_converted <- ggstatsplot::ggplot_converter(p)
class(p_converted)
}
