% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_plots.R
\name{combine_plots}
\alias{combine_plots}
\title{Combining and arranging multiple plots in a grid}
\usage{
combine_plots(..., title.text = NULL, title.color = "black",
  title.size = 16, title.vjust = 0.5, title.hjust = 0.5,
  title.fontface = "bold", caption.text = NULL,
  caption.color = "black", caption.size = 10, caption.vjust = 0.5,
  caption.hjust = 0.5, caption.fontface = "plain", sub.text = NULL,
  sub.color = "black", sub.size = 12, sub.vjust = 0.5,
  sub.hjust = 0.5, sub.fontface = "plain", sub.x = 0.5,
  sub.y = 0.5, sub.vpadding = grid::unit(1, "lines"), sub.angle = 0,
  sub.lineheight = 0.9, title.rel.heights = c(0.1, 1.2),
  caption.rel.heights = c(1.2, 0.1), title.caption.rel.heights = c(0.1,
  1.2, 0.1))
}
\arguments{
\item{...}{Additional arguments used in the function \code{cowplot::plot_grid()}.}

\item{title.text}{String or plotmath expression to be drawn as title for the
\emph{combined plot}.}

\item{title.color}{Text color for title.}

\item{title.size}{Point size of title text.}

\item{title.vjust}{Vertical justification for title. Default = \code{0.5}
(centered on \code{y}). \code{0} = baseline at \code{y}, \code{1} = ascender at \code{y}.}

\item{title.hjust}{Horizontal justification for title. Default = \code{0.5}
(centered on \code{x}). \code{0} = flush-left at x, \code{1} = flush-right.}

\item{title.fontface}{The font face (\code{"plain"}, \code{"bold"} (default),
\code{"italic"}, \code{"bold.italic"}) for title.}

\item{caption.text}{String or plotmath expression to be drawn as the caption
for the \emph{combined plot}.}

\item{caption.color}{Text color for caption.}

\item{caption.size}{Point size of title text.}

\item{caption.vjust}{Vertical justification for caption. Default = \code{0.5}
(centered on y). \code{0} = baseline at y, \code{1} = ascender at y.}

\item{caption.hjust}{Horizontal justification for caption. Default = \code{0.5}
(centered on x). \code{0} = flush-left at x, \code{1} = flush-right.}

\item{caption.fontface}{The font face (\code{"plain"} (default), \code{"bold"},
\code{"italic"}, \code{"bold.italic"}) for caption.}

\item{sub.text}{The label with which the \emph{combined plot} should be annotated.
Can be a plotmath expression.}

\item{sub.color}{Text color for annotation label (Default: \code{"black"}).}

\item{sub.size}{Point size of annotation text (Default: \code{12}).}

\item{sub.vjust}{Vertical justification for annotation label (Default:
\code{0.5}).}

\item{sub.hjust}{Horizontal justification for annotation label (Default:
\code{0.5}).}

\item{sub.fontface}{The font face (\code{"plain"} (default), \code{"bold"}, \code{"italic"},
\code{"bold.italic"}) for the annotation label.}

\item{sub.x}{The x position of annotation label (Default: \code{0.5}).}

\item{sub.y}{The y position of annotation label (Default: \code{0.5}).}

\item{sub.vpadding}{Vertical padding. The total vertical space added to the
label, given in grid units. By default, this is added equally above and
below the label. However, by changing the y and vjust parameters, this can
be changed (Default: \code{grid::unit(1, "lines")}).}

\item{sub.angle}{Angle at which annotation label is to be drawn (Default:
\code{0}).}

\item{sub.lineheight}{Line height of annotation label.}

\item{title.rel.heights}{Numerical vector of relative columns heights while
combining (title, plot).}

\item{caption.rel.heights}{Numerical vector of relative columns heights while
combining (plot, caption).}

\item{title.caption.rel.heights}{Numerical vector of relative columns heights
while combining (title, plot, caption).}
}
\value{
Combined plot with title and/or caption and/or annotation label
}
\description{
Wrapper around \code{\link[cowplot]{plot_grid}} that will return
a plotgrid along with a combination of title, caption, and annotation label
}
\examples{
# loading the necessary libraries
library(ggplot2)

# preparing the first plot
p1 <-
  ggplot2::ggplot(
    data = subset(iris, iris$Species == "setosa"),
    aes(x = Sepal.Length, y = Sepal.Width)
  ) +
  geom_point() +
  labs(title = "setosa")

# preparing the second plot
p2 <-
  ggplot2::ggplot(
    data = subset(iris, iris$Species == "versicolor"),
    aes(x = Sepal.Length, y = Sepal.Width)
  ) +
  geom_point() +
  labs(title = "versicolor")

# combining the plot with a title and a caption
combine_plots(
  p1,
  p2,
  labels = c("(a)", "(b)"),
  title.text = "Dataset: Iris Flower dataset",
  caption.text = "Note: Only two species of flower are displayed",
  title.color = "red",
  caption.color = "blue"
)
}
\references{
\url{https://indrajeetpatil.github.io/ggstatsplot/articles/web_only/combine_plots.html}
}
\author{
Indrajeet Patil
}
