% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_ggbetween_t_subtitles.R
\name{subtitle_t_bayes}
\alias{subtitle_t_bayes}
\title{Making text subtitle for the bayesian t-test.}
\usage{
subtitle_t_bayes(data, x, y, bf.prior = 0.707, paired = FALSE, k = 2,
  ...)
}
\arguments{
\item{data}{Dataframe from which variables specified are preferentially to be
taken.}

\item{x}{The grouping variable.}

\item{y}{The response - a vector of length the number of rows of \code{x}.}

\item{bf.prior}{A number between 0.5 and 2 (default \code{0.707}), the prior width
to use in calculating Bayes factors.}

\item{paired}{a logical indicating whether you want a paired
    t-test.}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{Additional arguments (ignored).}
}
\description{
Making text subtitle for the bayesian t-test.
}
\examples{
# for reproducibility
set.seed(123)

# between-subjects design

subtitle_t_bayes(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE
)

# within-subjects design

subtitle_t_bayes(
  data = dplyr::filter(
    ggstatsplot::intent_morality,
    condition \%in\% c("accidental", "attempted"),
    harm == "Poisoning"
  ),
  x = condition,
  y = rating,
  paired = TRUE
)
}
\author{
Indrajeet Patil
}
