% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_bf_tests.R
\name{bf_ttest}
\alias{bf_ttest}
\alias{bf_one_sample_ttest}
\alias{bf_two_sample_ttest}
\title{Bayes Factor for \emph{t}-test}
\usage{
bf_ttest(data, x, y = NULL, test.value = 0, paired = FALSE,
  bf.prior = 0.707, caption = NULL, output = "null", k = 2, ...)

bf_one_sample_ttest(data, x, y = NULL, test.value = 0,
  paired = FALSE, bf.prior = 0.707, caption = NULL,
  output = "null", k = 2, ...)

bf_two_sample_ttest(data, x, y = NULL, test.value = 0,
  paired = FALSE, bf.prior = 0.707, caption = NULL,
  output = "null", k = 2, ...)
}
\arguments{
\item{data}{A dataframe (or a tibble) from which variables specified are to
be taken. A matrix or tables will \strong{not} be accepted.}

\item{x}{Either the grouping variable from the dataframe \code{data} if it's a
two-sample \emph{t}-test or a numeric variable if it's a one-sample \emph{t}-test.}

\item{y}{The response (a.k.a. outcome or dependent) variable from the
dataframe \code{data}.}

\item{test.value}{A number specifying the value of the null hypothesis
(Default: \code{0}).}

\item{paired}{if \code{TRUE}, observations are paired}

\item{bf.prior}{A number between \code{0.5} and \code{2} (default \code{0.707}), the prior
width to use in calculating Bayes factors.}

\item{caption}{The text for the plot caption.}

\item{output}{Can either be \code{"null"} (or \code{"caption"} or \code{"H0"}, which will
contain text for evidence in favor of the null hypothesis or H0)  or
\code{"alternative"} (or \code{"title"} or \code{"H1"}) or \code{"results"}, which will return
a dataframe with results all the details).}

\item{k}{Number of digits after decimal point (should be an integer)
(Default: \code{k = 2}).}

\item{...}{further arguments to be passed to or from methods.}
}
\description{
Bayes Factor for \emph{t}-test
}
\details{
If \code{y} is \code{NULL}, a one-sample \emph{t}-test will be carried out,
otherwise a two-sample \emph{t}-test will be carried out.
}
\examples{

# ------------------- two-samples tests -----------------------------------

# for reproducibility
set.seed(123)

# to get caption (default)
bf_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  bf.prior = 0.880
)

# to see results
bf_ttest(
  data = mtcars,
  x = am,
  y = wt,
  paired = FALSE,
  output = "results"
)

# for paired sample test
bf_ttest(
  data = dplyr::filter(
    ggstatsplot::intent_morality,
    condition \%in\% c("accidental", "attempted"),
    harm == "Poisoning"
  ),
  x = condition,
  y = rating,
  paired = TRUE,
  output = "results"
)

# ------------------- one-samples test -----------------------------------

# to get caption (default)
bf_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85,
  bf.prior = 0.8,
  output = "caption", k = 2
)

# to get results dataframe
bf_ttest(
  data = iris,
  x = Sepal.Length,
  test.value = 5.85,
  bf.prior = 0.8,
  output = "results"
)
}
\seealso{
\code{\link{bf_contingency_tab}}, \code{\link{bf_corr_test}},
\code{\link{bf_oneway_anova}}
}
\author{
Indrajeet Patil
}
