% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common-plot-utils.R
\name{find_idfactor}
\alias{find_idfactor}
\title{Find 'idfactor'}
\usage{
find_idfactor(spct, idfactor, annotations, facets = FALSE, ...)
}
\arguments{
\item{spct}{generic_spct or derived object}

\item{idfactor}{character Name of an index column in data holding a
\code{factor} with each spectrum in a long-form multispectrum object
corresponding to a distinct spectrum. If \code{idfactor=NULL} the name of
the factor is retrieved from metadata or if no metadata found, the default
"spct.idx" is tried. If \code{idfactor=NA} no aesthetic is mapped to the
spectra and the user needs to use 'ggplot2' functions to manually map an
aesthetic or use facets for the spectra.}

\item{annotations}{a character vector.}

\item{facets}{logical or numeric Flag indicating if facets are to be created
when the data contains multiple spectra, if numeric the number of columns.}

\item{...}{currently not used.}
}
\value{
A list object containing a list of ggplot components and a vector of
  annotations names as members.
}
\description{
Find if an 'idfactor' is present and needed in the plot and assemble a
suitable plot layer to handle it.
}
\keyword{internal}
