% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wl-summary.R
\name{stat_wl_summary}
\alias{stat_wl_summary}
\title{Average area under curve for regions.}
\usage{
stat_wl_summary(mapping = NULL, data = NULL, geom = "text",
  range = NULL, integral.fun = integrate_xy, label.fmt = "\%.3g",
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{range}{a numeric vector of at least length two.}

\item{integral.fun}{function on $x$ and $y$.}

\item{label.fmt}{character string giving a format definition for converting
y-integral values into character strings by means of function \code{\link{sprintf}}.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{na.rm}{a logical value indicating whether NA values should be
stripped before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A data frame with one row.
}
\description{
\code{stat_wl_summary} computes the area under a curve.
}
\section{Computed variables}{

What it is named integral below is the result of appying \code{integral.fun},
with default \code{integrate_xy}.
\describe{
  \item{y.label}{y formatted according to \code{label.fmt}}
  \item{x}{w.band-midpoint}
  \item{xmin}{range minimum}
  \item{xmax}{range maximum}
  \item{y}{data$y integral for the range by the spread of the range}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{..label..}
  \item{x}{..x..}
  \item{xmin}{..xmin..}
  \item{xmax}{..xmax..}
  \item{y}{..y..}
  \item{ymin}{0}
  \item{ymax}{..y..}
  \item{yintercept}{..y..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{
library(photobiology)
library(ggplot2)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) + geom_line() +
  stat_wl_summary(geom = "hline")
ggplot(sun.spct) + geom_line() +
  stat_wl_summary(label.fmt = "mean = \%.3f", color = "red", vjust = -0.3) +
  stat_wl_summary(geom = "hline", color = "red")

}
\seealso{
Other stats functions: \code{\link{stat_color}},
  \code{\link{stat_label_peaks}}, \code{\link{stat_peaks}},
  \code{\link{stat_wb_box}}, \code{\link{stat_wb_column}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_hbar}}, \code{\link{stat_wb_irrad}},
  \code{\link{stat_wb_label}}, \code{\link{stat_wb_mean}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wl_strip}}
}
