% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-polypath.R
\name{geom_polypath}
\alias{geom_polypath}
\title{Polygons with holes in ggplot2}
\usage{
geom_polypath(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  rule = "winding",
  ...
)
}
\arguments{
\item{mapping}{An aesthetic mapping, created with \link[ggplot2:aes]{aes}. The aesthetic
will mostly likely need to contain a \code{group} mapping.}

\item{data}{A data.frame containing the coordinates to plot.}

\item{stat}{A statistic to apply (most likely "identity")}

\item{position}{A position to apply (most likely "identity")}

\item{na.rm}{Should missing coordinate be removed?}

\item{show.legend}{Should a legend be shown for mapped aesthetics?}

\item{inherit.aes}{Should aesthetics be inherited?}

\item{rule}{A fill rule to apply. One of "winding" or "evenodd".}

\item{...}{Passed to the geom and/or stat.}
}
\value{
A ggplot2 layer
}
\description{
This geometry used to plot polygons with holes in ggplot2 at the
more correctly than \link[ggplot2:geom_polygon]{geom_polygon}; however,
in recent R and ggplot2 versions this is no longer needed.
}
\examples{
\donttest{
library(ggplot2)
load_longlake_data(which = "longlake_waterdf")
ggplot(df_spatial(longlake_waterdf), aes(x, y, group = piece_id)) +
  geom_polypath()
}

}
