% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facet_graph.R
\name{facet_graph}
\alias{facet_graph}
\title{Create a grid of small multiples by node and/or edge attributes}
\usage{
facet_graph(
  facets,
  row_type = "edge",
  col_type = "node",
  margins = FALSE,
  scales = "fixed",
  space = "fixed",
  shrink = TRUE,
  labeller = "label_value",
  as.table = TRUE,
  switch = NULL,
  drop = TRUE
)
}
\arguments{
\item{facets}{This argument is soft-deprecated, please use \code{rows}
and \code{cols} instead.}

\item{row_type, col_type}{Either \code{'node'} or \code{'edge'}. Which data
type is being facetted in the rows and columns. Default is to facet on nodes
column wise and on edges row wise.}

\item{margins}{Either a logical value or a character
vector. Margins are additional facets which contain all the data
for each of the possible values of the faceting variables. If
\code{FALSE}, no additional facets are included (the
default). If \code{TRUE}, margins are included for all faceting
variables. If specified as a character vector, it is the names of
variables for which margins are to be created.}

\item{scales}{Are scales shared across all facets (the default,
\code{"fixed"}), or do they vary across rows (\code{"free_x"}),
columns (\code{"free_y"}), or both rows and columns (\code{"free"})?}

\item{space}{If \code{"fixed"}, the default, all panels have the same size.
If \code{"free_y"} their height will be proportional to the length of the
y scale; if \code{"free_x"} their width will be proportional to the
length of the x scale; or if \code{"free"} both height and width will
vary.  This setting has no effect unless the appropriate scales also vary.}

\item{shrink}{If \code{TRUE}, will shrink scales to fit output of
statistics, not raw data. If \code{FALSE}, will be range of raw data
before statistical summary.}

\item{labeller}{A function that takes one data frame of labels and
returns a list or data frame of character vectors. Each input
column corresponds to one factor. Thus there will be more than
one with \code{vars(cyl, am)}. Each output
column gets displayed as one separate line in the strip
label. This function should inherit from the "labeller" S3 class
for compatibility with \code{\link[ggplot2:labeller]{labeller()}}. You can use different labeling
functions for different kind of labels, for example use \code{\link[ggplot2:labellers]{label_parsed()}} for
formatting facet labels. \code{\link[ggplot2:labellers]{label_value()}} is used by default,
check it for more details and pointers to other options.}

\item{as.table}{If \code{TRUE}, the default, the facets are laid out like
a table with highest values at the bottom-right. If \code{FALSE}, the
facets are laid out like a plot with the highest value at the top-right.}

\item{switch}{By default, the labels are displayed on the top and
right of the plot. If \code{"x"}, the top labels will be
displayed to the bottom. If \code{"y"}, the right-hand side
labels will be displayed to the left. Can also be set to
\code{"both"}.}

\item{drop}{If \code{TRUE}, the default, all factor levels not used in the
data will automatically be dropped. If \code{FALSE}, all factor levels
will be shown, regardless of whether or not they appear in the data.}
}
\description{
This function is equivalent to \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} in that it
allows for building a grid of small multiples where rows and columns
correspond to a specific data value. While \code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}}
could be used it would lead to unexpected results as it is not possible to
specify whether you are referring to a node or an edge attribute. Furthermore
\code{\link[ggplot2:facet_grid]{ggplot2::facet_grid()}} will draw edges in panels even though the
panel does not contain both terminal nodes. \code{facet_graph} takes care of
all of these issues, allowing you to define which data type the rows and
columns are referencing as well as filtering the edges based on the nodes in
each panel (even when nodes are not drawn).
}
\examples{
library(tidygraph)
gr <- as_tbl_graph(highschool) \%>\%
  mutate(popularity = as.character(cut(centrality_degree(mode = 'in'),
    breaks = 3,
    labels = c('low', 'medium', 'high')
  )))
ggraph(gr) +
  geom_edge_link() +
  geom_node_point() +
  facet_graph(year ~ popularity)
}
\seealso{
Other ggraph-facets: 
\code{\link{facet_edges}()},
\code{\link{facet_nodes}()}
}
\concept{ggraph-facets}
