% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_pmds.R
\name{layout_tbl_graph_pmds}
\alias{layout_tbl_graph_pmds}
\title{Place nodes based on a multidimensional scaling of a set of pivot nodes}
\usage{
layout_tbl_graph_pmds(graph, pivots, weights = NULL, circular = FALSE)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{pivots}{The number of pivot nodes}

\item{weights}{An expression evaluated on the edge data to provide edge
weights for the layout. Currently ignored for the sparse version}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout is similar to the 'mds' layout but uses only a subset of pivot
nodes for the mds calculation, making it considerably faster and thus suited
for large graphs
}
\references{
Brandes, U. and Pich, C. (2006). \emph{Eigensolver Methods for Progressive
Multidimensional Scaling of Large Data.} In International Symposium on Graph
Drawing (pp. 42-53). Springer
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_auto}},
  \code{\link{layout_tbl_graph_backbone}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_eigen}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_igraph}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_partition}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
