% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_eigen.R
\name{layout_tbl_graph_eigen}
\alias{layout_tbl_graph_eigen}
\title{Place nodes according to their eigenvalues}
\usage{
layout_tbl_graph_eigen(graph, type = "laplacian",
  eigenvector = "smallest", circular = FALSE)
}
\arguments{
\item{graph}{A tbl_graph object}

\item{type}{The type of matrix to extract the eigenvectors from. Either
\code{'laplacian'} or \code{'adjacency'}}

\item{eigenvector}{The eigenvector to use for coordinates. Either \code{'smallest'}
or \code{'largest'}}

\item{circular}{ignored}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} as
well as any information stored as node variables in the tbl_graph object.
}
\description{
This layout is based on the idea of spectral layouts where node coordinates
are calculated directly by decomposing a matrix representation of the graph
and extracting the eigenvectors.
}
\seealso{
Other layout_tbl_graph_*: \code{\link{layout_tbl_graph_auto}},
  \code{\link{layout_tbl_graph_backbone}},
  \code{\link{layout_tbl_graph_centrality}},
  \code{\link{layout_tbl_graph_circlepack}},
  \code{\link{layout_tbl_graph_dendrogram}},
  \code{\link{layout_tbl_graph_fabric}},
  \code{\link{layout_tbl_graph_focus}},
  \code{\link{layout_tbl_graph_hive}},
  \code{\link{layout_tbl_graph_igraph}},
  \code{\link{layout_tbl_graph_linear}},
  \code{\link{layout_tbl_graph_manual}},
  \code{\link{layout_tbl_graph_matrix}},
  \code{\link{layout_tbl_graph_partition}},
  \code{\link{layout_tbl_graph_pmds}},
  \code{\link{layout_tbl_graph_stress}},
  \code{\link{layout_tbl_graph_treemap}},
  \code{\link{layout_tbl_graph_unrooted}}
}
\author{
The underlying algorithm is implemented in the graphlayouts package
by David Schoch
}
\concept{layout_tbl_graph_*}
