% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiraph.R
\name{ggiraph}
\alias{ggiraph}
\title{create a ggiraph object}
\usage{
ggiraph(code, ggobj = NULL, pointsize = 12, width = NULL, width_svg = 6,
  height_svg = 6, tooltip_extra_css, hover_css, tooltip_opacity = 0.9,
  tooltip_offx = 10, tooltip_offy = 0, zoom_max = 1,
  selection_type = "multiple", selected_css, flexdashboard = NULL, ...)
}
\arguments{
\item{code}{Plotting code to execute}

\item{ggobj}{ggplot objet to print. argument \code{code} will
be ignored if this argument is supplied.}

\item{pointsize}{the default pointsize of plotted text in pixels, default to 12.}

\item{width, flexdashboard}{deprecated}

\item{width_svg, height_svg}{svg viewbox width and height in inches}

\item{tooltip_extra_css}{extra css (added to \code{position: absolute;pointer-events: none;})
used to customize tooltip area.}

\item{hover_css}{css to apply when mouse is hover and element with a data-id attribute.}

\item{tooltip_opacity}{tooltip opacity}

\item{tooltip_offx}{tooltip x offset}

\item{tooltip_offy}{tooltip y offset}

\item{zoom_max}{maximum zoom factor}

\item{selection_type}{row selection mode ("single", "multiple", "none")
when widget is in a Shiny application.}

\item{selected_css}{css to apply when element is selected (shiny only).}

\item{...}{arguments passed on to \code{\link[rvg]{dsvg}}}
}
\description{
Create an interactive graphic to be used in a web browser.

Use \code{geom_zzz_interactive} to create interactive graphical elements.

Difference from original functions is that the following
aesthetics are understood: \code{tooltip}, \code{onclick}
and \code{data_id}.

Tooltips can be displayed when mouse is over graphical elements.

If id are associated with points, they get animated when mouse is
over and can be selected when used in shiny apps.

On click actions can be set with javascript instructions. This option
should not be used simultaneously with selections in Shiny
applications as both features are "on click" features.

When \code{zoom_max} is set, "zoom activate", "zoom desactivate" and
"zoom init" buttons are available in a toolbar.

When \code{selection} is set to multiple (in Shiny applications), lasso
selection and lasso anti-selections buttons are available in a toolbar.
}
\examples{
# ggiraph simple example -------
# create dataset
dataset = iris
dataset$tooltip = dataset$Species
dataset$clickjs = paste0("alert(\\"",dataset$Species, "\\")" )

# plots
gg_point = ggplot(dataset, aes(x = Sepal.Length, y = Petal.Width,
		color = Species, tooltip = tooltip, onclick = clickjs) ) +
	geom_point_interactive()

ggiraph(code = {print(gg_point)})
}
