#' LivLab
#' 
#' @description 
#' A data frame containing a sample with the results of neuropsychological assessment 
#' before and after serious game intervention in the living lab, Thess-AHALL 
#' (Thessaloniki Active and Healthy Aging Living Lab) 
#' of Medical Physics Laboratory of Aristotle University of Thessaloniki.
#' @usage LivLab
#' 
#' @docType data
#' 
#' @format A data frame with 10 observations of 2 columns:
#' \describe{
#'   \item{\code{before}}{score in a neuropsychological test before serious game intervention}
#'   \item{\code{after}}{score in a neuropsychological test after serious game intervention}
#'   }
#' 
#' @name LivLab
#' 
#' @source <http://aha-livinglabs.com/>
#' 
NULL

# A data frame containing a sample with the results of neuropsychological assessment 
# before and after serious game intervention in Thess-AHALL living lab (Thessaloniki Active and Healthy Aging Living Lab),
# of Medical Physics Laboratory of Aristotle University of Thessaloniki.
# 
# 
# The Medical Physics Laboratory of Aristotle University of Thessaloniki.
# has a living lab, Thess-AHALL (Thessaloniki Active and Healthy Aging Living Lab),
# in which healthy elderly and elderly with mild cognitive impairment, participate
# in mental empowerment interventions with the use of serious toys,
# to improve their mental capacity.
# Their progress is assessed using a neuropsychological assessment tool
# that takes place before and after the intervention is completed.
# The LivLab data frame from the gginference library contains a data sample with
# a score of 10 participants before and after the session.