% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans.R
\name{power_trans}
\alias{power_trans}
\title{Create a power transformation object}
\usage{
power_trans(n)
}
\arguments{
\item{n}{The degree of the power transformation}
}
\value{
A trans object
}
\description{
This function can be used to create a proper trans object that encapsulates
a power transformation (x^n).
}
\examples{
# Power of 5 transformations
trans <- power_trans(2)
trans$transform(1:10)

# Cubic root transformation
trans <- power_trans(1/3)
trans$transform(1:10)

# Use it in a plot
ggplot() + geom_line(aes(x=1:10, y=1:10)) +
  scale_x_continuous(trans = power_trans(2), expand=c(0,1))

}

