% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R, R/print.R
\name{format.ggeffects}
\alias{format.ggeffects}
\alias{print}
\alias{print.ggeffects}
\alias{print_md.ggeffects}
\alias{print_html.ggeffects}
\title{Print and format ggeffects-objects}
\usage{
\method{format}{ggeffects}(
  x,
  variable_labels = FALSE,
  value_labels = FALSE,
  group_name = FALSE,
  row_header_separator = ", ",
  digits = 2,
  collapse_ci = FALSE,
  collapse_tables = FALSE,
  n,
  ...
)

\method{print}{ggeffects}(x, group_name = TRUE, digits = 2, verbose = TRUE, ...)

\method{print_md}{ggeffects}(x, group_name = TRUE, digits = 2, ...)

\method{print_html}{ggeffects}(
  x,
  group_name = TRUE,
  digits = 2,
  theme = NULL,
  engine = c("tt", "gt"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{ggeffects}, as returned by the functions
from this package.}

\item{variable_labels}{Logical, if \code{TRUE} variable labels are used as column
headers. If \code{FALSE}, variable names are used.}

\item{value_labels}{Logical, if \code{TRUE}, value labels are used as values in
the table output. If \code{FALSE}, the numeric values or factor levels are used.}

\item{group_name}{Logical, if \code{TRUE}, the name of further focal terms are
used in the sub-headings of the table. If \code{FALSE}, only the values of the
focal terms are used.}

\item{row_header_separator}{Character, separator between the different
subgroups in the table output.}

\item{digits}{Number of digits to print.}

\item{collapse_ci}{Logical, if \code{TRUE}, the columns with predicted values and
confidence intervals are collapsed into one column, e.g. \verb{Predicted (95\% CI)}.}

\item{collapse_tables}{Logical, if \code{TRUE}, all tables are combined into one.
The tables are not split by further focal terms, but rather are added as
columns. Only works when there is more than one focal term.}

\item{n}{Number of rows to print per subgroup. If \code{NULL}, a default number
of rows is printed, depending on the number of subgroups.}

\item{...}{Further arguments passed down to \code{\link[=format.ggeffects]{format.ggeffects()}}, some of
them are also passed down further to \code{\link[insight:format_table]{insight::format_table()}} or
\code{\link[insight:format_value]{insight::format_value()}}.}

\item{verbose}{Toggle messages.}

\item{theme}{The theme to apply to the table. One of \code{"grid"}, \code{"striped"},
\code{"bootstrap"}, or \code{"darklines"}.}

\item{engine}{The engine to use for printing. One of \code{"tt"} (default) or \code{"gt"}.
\code{"tt"} uses the \emph{tinytable} package, \code{"gt"} uses the \emph{gt} package.}
}
\value{
\code{format()} return a formatted data frame, \code{print()} prints a formatted
data frame printed to the console. \code{print_html()} returns a \code{tinytable}
object by default (unless changed with \code{engine = "gt"}), which is printed as
HTML, markdown or LaTeX table (depending on the context from which
\code{print_html()} is called, see \code{\link[tinytable:tt]{tinytable::tt()}} for details).
}
\description{
A generic print-method for \code{ggeffects}-objects.
}
\section{Global Options to Customize Tables when Printing}{

The \code{verbose} argument can be used to display or silence messages and
warnings. Furthermore, \code{options()} can be used to set defaults for the
\code{print()} and \code{print_html()} method. The following options are available,
which can simply be run in the console:
\itemize{
\item \code{ggeffects_ci_brackets}: Define a character vector of length two, indicating
the opening and closing parentheses that encompass the confidence intervals
values, e.g. \code{options(ggeffects_ci_brackets = c("[", "]"))}.
\item \code{ggeffects_collapse_ci}: Logical, if \code{TRUE}, the columns with predicted
values (or contrasts) and confidence intervals are collapsed into one
column, e.g. \code{options(ggeffects_collapse_ci = TRUE)}.
\item \code{ggeffects_collapse_p}: Logical, if \code{TRUE}, the columns with predicted
values (or contrasts) and p-values are collapsed into one column, e.g.
\code{options(ggeffects_collapse_p = TRUE)}. Note that p-values are replaced
by asterisk-symbols (stars) or empty strings when \code{ggeffects_collapse_p = TRUE},
depending on the significance level.
\item \code{ggeffects_collapse_tables}: Logical, if \code{TRUE}, multiple tables for
subgroups are combined into one table. Only works when there is more than
one focal term, e.g. \code{options(ggeffects_collapse_tables = TRUE)}.
\item \code{ggeffects_output_format}: String, either \code{"text"}, \code{"markdown"} or \code{"html"}.
Defines the default output format from \code{predict_response()}. If \code{"html"}, a
formatted HTML table is created and printed to the view pane. \code{"markdown"}
creates a markdown-formatted table inside Rmarkdown documents, and prints
a text-format table to the console when used interactively. If \code{"text"} or
\code{NULL}, a formatted table is printed to the console, e.g.
\code{options(ggeffects_output_format = "html")}.
\item \code{ggeffects_html_engine}: String, either \code{"tt"} or \code{"gt"}. Defines the default
engine to use for printing HTML tables. If \code{"tt"}, the \emph{tinytable} package
is used, if \code{"gt"}, the \emph{gt} package is used, e.g.
\code{options(ggeffects_html_engine = "gt")}.
}

Use \verb{options(<option_name> = NULL)} to remove the option.
}

\examples{
\dontshow{if (requireNamespace("datawizard", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(efc, package = "ggeffects")
fit <- lm(barthtot ~ c12hour + e42dep, data = efc)

# default print
predict_response(fit, "e42dep")

# surround CI values with parentheses
print(predict_response(fit, "e42dep"), ci_brackets = c("(", ")"))
# you can also use `options(ggeffects_ci_brackets = c("[", "]"))`
# to set this globally

# collapse CI columns into column with predicted values
print(predict_response(fit, "e42dep"), collapse_ci = TRUE)

# include value labels
print(predict_response(fit, "e42dep"), value_labels = TRUE)

# include variable labels in column headers
print(predict_response(fit, "e42dep"), variable_labels = TRUE)

# include value labels and variable labels
print(predict_response(fit, "e42dep"), variable_labels = TRUE, value_labels = TRUE)

data(iris)
m <- lm(Sepal.Length ~ Species * Petal.Length, data = iris)

# default print with subgroups
predict_response(m, c("Petal.Length", "Species"))

# omit name of grouping variable in subgroup table headers
print(predict_response(m, c("Petal.Length", "Species")), group_name = FALSE)

# collapse tables into one
print(predict_response(m, c("Petal.Length", "Species")), collapse_tables = TRUE, n = 3)

# increase number of digits
print(predict_response(fit, "e42dep"), digits = 5)
\dontshow{\}) # examplesIf}
}
