% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_lineribbon.R
\name{geom_lineribbon}
\alias{geom_lineribbon}
\title{Line + multiple-ribbon plots (ggplot geom)}
\usage{
geom_lineribbon(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  step = FALSE,
  orientation = NA,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat.}

\item{step}{Should the line/ribbon be drawn as a step function? One of:
\itemize{
\item \code{FALSE} (default): do not draw as a step function.
\item \code{"mid"} (or \code{TRUE}): draw steps midway between adjacent x values.
\item \code{"hv"}: draw horizontal-then-vertical steps.
\item \code{"vh"}: draw as vertical-then-horizontal steps.
}
\code{TRUE} is an alias for \code{"mid"} because for a step function with ribbons, \code{"mid"} is probably what you want
(for the other two step approaches the ribbons at either the very first or very last x value will not be
visible).}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} representing a combined line + multiple-ribbon geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
A combination of \code{\link[=geom_line]{geom_line()}} and \code{\link[=geom_ribbon]{geom_ribbon()}} with default aesthetics
designed for use with output from \code{\link[=point_interval]{point_interval()}}.
}
\details{
\code{\link[=geom_lineribbon]{geom_lineribbon()}} is a combination of a \code{\link[=geom_line]{geom_line()}} and \code{\link[=geom_ribbon]{geom_ribbon()}} designed for use
with output from \code{\link[=point_interval]{point_interval()}}. This geom sets some default aesthetics equal to the \code{.width}
column generated by the \code{\link[=point_interval]{point_interval()}} family of functions, making them
often more convenient than a vanilla \code{\link[=geom_ribbon]{geom_ribbon()}} + \code{\link[=geom_line]{geom_line()}}.

Specifically, \code{\link[=geom_lineribbon]{geom_lineribbon()}} acts as if its default aesthetics are
\code{aes(fill = forcats::fct_rev(ordered(.width)))}.
}
\section{Aesthetics}{

The line+ribbon \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their two sub-geometries: the \strong{line} and the \strong{ribbon}.

\strong{Positional aesthetics}

\itemize{
\item{\code{x}: x position of the geometry}
\item{\code{y}: y position of the geometry}
}

\strong{Ribbon-specific aesthetics}

\itemize{
\item{\code{xmin}: Left edge of the ribbon sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{xmax}: Right edge of the ribbon sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{ymin}: Lower edge of the ribbon sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{ymax}: Upper edge of the ribbon sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{order}: The order in which ribbons are drawn. Ribbons with the smallest mean value of \code{order}
are drawn first (i.e., will be drawn below ribbons with larger mean values of \code{order}). If
\code{order} is not supplied to \code{\link[=geom_lineribbon]{geom_lineribbon()}}, \code{-abs(xmax - xmin)} or \code{-abs(ymax - ymax)}
(depending on \code{orientation}) is used, having the effect of drawing the widest (on average)
ribbons on the bottom. \code{\link[=stat_lineribbon]{stat_lineribbon()}} uses \code{order = after_stat(level)} by default,
causing the ribbons generated from the largest \code{.width} to be drawn on the bottom.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{line} sub-geometry.}
\item{\code{fill}: The fill color of the \strong{ribbon} sub-geometry.}
\item{\code{alpha}: The opacity of the \strong{line} and \strong{ribbon} sub-geometries.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of \strong{line}. In \pkg{ggplot2} < 3.4, was called \code{size}.}
\item{\code{linetype}: Type of \strong{line} (e.g., \code{"solid"}, \code{"dashed"}, etc)}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("lineribbon")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

theme_set(theme_ggdist())

set.seed(12345)
tibble(
  x = rep(1:10, 100),
  y = rnorm(1000, x)
) \%>\%
  group_by(x) \%>\%
  median_qi(.width = c(.5, .8, .95)) \%>\%
  ggplot(aes(x = x, y = y, ymin = .lower, ymax = .upper)) +
  # automatically uses aes(fill = forcats::fct_rev(ordered(.width)))
  geom_lineribbon() +
  scale_fill_brewer()

}
\seealso{
See \code{\link[=stat_lineribbon]{stat_lineribbon()}} for a version that does summarizing of samples into points and intervals
within ggplot. See \code{\link[=geom_pointinterval]{geom_pointinterval()}} for a similar geom intended
for point summaries and intervals. See \code{\link[=geom_ribbon]{geom_ribbon()}} and \code{\link[=geom_line]{geom_line()}} for the geoms this is
based on.
}
\author{
Matthew Kay
}
